// Lab three is part of the "lab3" package
package sokoban;

// Some handy includes
import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.Event;
import java.awt.event.*;
import sokoban.*;

//
// This is the "view" of the MVC design layout
//
public class sView extends JPanel 
{
    // A "pointer" to the board object that 
    // this view is responsible for drawing.
    private sBoard sboard;

    // Some constants
    public static final int SIZE = 24;

    ///////////////////////////////////////////////////////////////////////////////
    //                                Constructor
    ///////////////////////////////////////////////////////////////////////////////

    // Constructor
    public sView(sBoard aboard) 
    {
	// Save the board so we know what to draw
	sboard = aboard;
    }

    ///////////////////////////////////////////////////////////////////////////////
    //                                PaintCompnent()
    ///////////////////////////////////////////////////////////////////////////////

    // This draws the sokoban board
    protected void paintComponent(Graphics g) 
    {
	double cWidth = getWidth(), cHeight = getHeight();
	int i,j;
	    
	Graphics2D  g2 = (Graphics2D) g;
	Color       fg = getForeground();
	    
	// Clear the whole mess and do some setup
	g2.setPaint(Color.black);
	g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
	g2.fill(new Rectangle2D.Double(0, 0, cWidth, cHeight));
	g2.setFont(new Font("Times", Font.BOLD, 24));

	// Obly draw the board if it is valid
	if( sboard.isValid() ) {
	    // Draw the board
	    for(i=0; i<sboard.getHeight(); i++) {
		for(j=0; j<sboard.getWidth(); j++) {
		    switch(sboard.getSquare(j,i)) {
		    case sBoard.WALL: 
			g2.setPaint(Color.gray);
			g2.fill(new Rectangle2D.Double(j*SIZE+cWidth/2-(sboard.getWidth()*SIZE)/2,
						       i*SIZE+cHeight/2-(sboard.getHeight()*SIZE)/2,
						       SIZE+1, SIZE+1));
			g2.setPaint(Color.darkGray);
			g2.draw(new Rectangle2D.Double(j*SIZE+cWidth/2-(sboard.getWidth()*SIZE)/2,
						       i*SIZE+cHeight/2-(sboard.getHeight()*SIZE)/2,
						       SIZE, SIZE));
			break;
		    case sBoard.BALL:
			g2.setPaint(Color.cyan);
			g2.fill(new Ellipse2D.Double(j*SIZE+cWidth/2-(sboard.getWidth()*SIZE)/2+1,
						     i*SIZE+cHeight/2-(sboard.getHeight()*SIZE)/2+1,
						     SIZE-2, SIZE-2));
			g2.setPaint(Color.blue);
			g2.fill(new Ellipse2D.Double(j*SIZE+cWidth/2-(sboard.getWidth()*SIZE)/2+2,
						     i*SIZE+cHeight/2-(sboard.getHeight()*SIZE)/2+2,
						     SIZE-4, SIZE-4));
			break;
		    case sBoard.GOAL:
			g2.setPaint(Color.yellow);
			g2.fill(new Rectangle2D.Double(j*SIZE+SIZE/4+cWidth/2-(sboard.getWidth()*SIZE)/2,
						       i*SIZE+SIZE/4+cHeight/2-(sboard.getHeight()*SIZE)/2,
						       SIZE/2, SIZE/2));
			g2.setPaint(Color.green);
			g2.fill(new Rectangle2D.Double(j*SIZE+SIZE/4+cWidth/2-(sboard.getWidth()*SIZE)/2+2,
						       i*SIZE+SIZE/4+cHeight/2-(sboard.getHeight()*SIZE)/2+2,
						       SIZE/2-4, SIZE/2-4));
			break;
		    }
		}
	    }
	
	    // Draw the person
	    g2.setPaint(Color.pink);
	    g2.fill(new Ellipse2D.Double(sboard.getX()*SIZE+cWidth/2-(sboard.getWidth()*SIZE)/2+1,
					 sboard.getY()*SIZE+cHeight/2-(sboard.getHeight()*SIZE)/2+1,
					 SIZE-2, SIZE-2));
	    g2.setPaint(Color.magenta);
	    g2.fill(new Ellipse2D.Double(sboard.getX()*SIZE+cWidth/2-(sboard.getWidth()*SIZE)/2+3,
					 sboard.getY()*SIZE+cHeight/2-(sboard.getHeight()*SIZE)/2+3,
					 SIZE-6, SIZE-6));
	}

	// Restore the fg color
	g2.setPaint(fg);
    }

    ///////////////////////////////////////////////////////////////////////////////
    //                              getPreferredSize
    ///////////////////////////////////////////////////////////////////////////////
	
    // Sets the prefered size of the canvas
    public Dimension getPreferredSize() 
    {
	if( sboard.isValid() ) {
	    return new Dimension((sboard.getWidth()+1)*SIZE, (sboard.getHeight()+1)*SIZE);
	} 

	return new Dimension(640, 480);
    }
}

