// Lab three is part of the "lab3" package
package sokoban;

// Some handy includes
import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.Event;
import java.awt.event.*;
import sokoban.*;

//
// This is a model/view combination which tracks the user's score
//
public class sScore extends JPanel 
{
    // Score state
    private int moves  = 0;
    private int pushes = 0;

    // Cache of the font object we will draw with
    private Font font = new Font("Times", Font.BOLD, 16);

    // Constructor
    public sScore() 
    {
    }

    ///////////////////////////////////////////////////////////////////////////////
    //                             State Read Members
    ///////////////////////////////////////////////////////////////////////////////
    
    public int getMoves()
    {
	return moves;
    }

    public int getPushes()
    {
	return pushes;
    }

    ///////////////////////////////////////////////////////////////////////////////
    //                         State Modification Members
    ///////////////////////////////////////////////////////////////////////////////

    // This method sets all scores to 0
    public void reset() 
    {
	moves  = 0;
	pushes = 0;
    }

    // This method increments moves by n
    public void inc_moves(int n)
    {
	moves += n;
    }

    // This method increments pushes by n
    public void inc_pushes(int n)
    {
	pushes += n;
    }

    ///////////////////////////////////////////////////////////////////////////////
    //                         Draw and getPreferredSize()
    ///////////////////////////////////////////////////////////////////////////////

    // This draws the score display
    protected void paintComponent(Graphics g) 
    {
	double cWidth = getWidth(), cHeight = getHeight();
	    
	Graphics2D  g2 = (Graphics2D) g;
	Color       fg = getForeground();
	FontMetrics fm = g.getFontMetrics(font);
	    
	// Clear the whole mess and do some setup
	g2.setPaint(getBackground());
	g2.fill(new Rectangle2D.Double(0, 0, cWidth, cHeight));
	g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
	g2.setFont(font);
	g2.setPaint(Color.black);

	// Draw the "scores"
	String moves_s = "Moves:" + String.valueOf(moves);
	g2.drawString(moves_s, 5, fm.getAscent());
	String pushes_s = "Pushes:" + String.valueOf(pushes);
	g2.drawString(pushes_s, fm.stringWidth(moves_s)+20, fm.getAscent());

	// Restore the color
	g2.setPaint(fg);
    }
	
    // Sets the prefered size of the score-board
    public Dimension getPreferredSize() 
    {
	FontMetrics fm = getGraphics().getFontMetrics(font);

	return new Dimension(fm.stringWidth("Moves:     ")+fm.stringWidth("Pushes:     ")+30, fm.getHeight());
    }
}

