#ifndef PTREE_H
#define PTREE_H

// Strength of rubber bands
#define FORCE_SCALE    50.0
#define BAND_STRENGTH  0.0001
#define GRAV_STRENGTH  2.0

typedef unsigned long ulong;
typedef unsigned char byte;

// Custom font structure
typedef struct {
  int          w;
  int          h;
  unsigned int f;  
} glFont, *pFont;

// Window information grouped together
typedef struct {
  Display             *dpy;
  int                  screen;
  Window               win;
  GLXContext           ctx;
  XSetWindowAttributes attr;
  int                  x, y;
  unsigned int         width, height;
  unsigned int         depth;   
  glFont               font;
  int                  id;
} GLWindow;

// Attribute lists for single and double buffered windows
static int attrListSgl[] = { 
  GLX_RGBA, GLX_RED_SIZE, 4,
  GLX_GREEN_SIZE, 4, 
  GLX_BLUE_SIZE, 4, 
  GLX_DEPTH_SIZE, 16,
  None 
};
static int attrListDbl[] = { 
  GLX_RGBA, GLX_DOUBLEBUFFER, 
  GLX_RED_SIZE, 4, 
  GLX_GREEN_SIZE, 4, 
  GLX_BLUE_SIZE, 4, 
  GLX_DEPTH_SIZE, 16,
  None 
};

// pTree node
typedef struct treen {
  // Tree info
  struct treen  *p;      // Parent
  struct treen **c;      // Children
  int            nc;     // Number of children
  char          *n;      // Command line (name)
  char          *o;      // Owner
  int            pid;    // Process id
  int            d;      // Depth
  // Dynamics
  double         v[3];   // Velocity
  double         l[3];   // Location
  double         m;      // Movable
  int            s;      // Selected
} Treen, *pTreen;

#endif
