#ifndef VIEW_H
#define VIEW_H

#define PI ((double)3.1415926535897932384)

#define CLIENT 0
#define SERVER 1

// Label modes
#define LM_DOUBLE  0
#define LM_INT     1
#define LM_SCALED  2
#define LM_NONE    3

// This groups a lot of information about a window togther
typedef struct {
  Display             *dpy;
  int                  screen;
  Window               win;
  GLXContext           ctx;
  XSetWindowAttributes attr;
  int                  x, y;
  unsigned int         width, height;
  unsigned int         depth;   
  GLuint               font;
  int                  id;
} GLWindow;

// Attribute lists for single and double buffered windows
static int attrListSgl[] = { 
  GLX_RGBA, GLX_RED_SIZE, 4,
  GLX_GREEN_SIZE, 4, 
  GLX_BLUE_SIZE, 4, 
  GLX_DEPTH_SIZE, 16,
  None 
};
static int attrListDbl[] = { 
  GLX_RGBA, GLX_DOUBLEBUFFER, 
  GLX_RED_SIZE, 4, 
  GLX_GREEN_SIZE, 4, 
  GLX_BLUE_SIZE, 4, 
  GLX_DEPTH_SIZE, 16,
  None 
};

// Enough information about an image to build a texture out of it
typedef struct {
  int            width;
  int            height;
  unsigned char *data;
} textureImage;

// These just make vectors a little cleaner
typedef struct {
  float  x;
  float  y;
  float  z;
} point3f;

typedef struct {
  int x;
  int y;
  int z;
} point3i;

// This is the maximum number of clients this client/server model supports.
// To support more, there will be some rewriting needed, so don't think this
// is simply a parameter you can change.
#define MAX_PARTICIPANTS 16

// This structure holds all data about a participant of the chat system
typedef struct {
  struct sockaddr_in saddr;
  int                saddr_len;
  point3i            pos;
  int                ticks;
  char               text[32];
  char               name[8];
  unsigned char      avatar;
} Participant;

// This structure represents a client update packet
typedef struct {
  point3i       pos;
  char          text[32];
  char          name[8];
  unsigned char avatar;
  unsigned char padding;
} ClientUpdate;

// Global update header
typedef struct {
  unsigned char  n;
  unsigned char  wl;
  unsigned short chksum;
} GlobalUpdateHdr;

#endif
