#include <math.h>
#include "gui_util.h"


/**
 * Converts a color in HSV colorspace to one in RGB, according to the algorithm
 * at http://en.wikipedia.org/wiki/HSL_and_HSV
 */
void hsv_to_rgb(float  h, float  s, float  v,
                float *r, float *g, float *b)
{
  float min, chroma, hdash, x;

  chroma = s * v;
  hdash  = h / 60.0f;
  x      = chroma * (1.0 - fabs(fmodf(hdash, 2.0) - 1.0));

  *r = 0.0f;
  *g = 0.0f;
  *b = 0.0f;

  if(hdash < 1.0) {
    *r = chroma;
    *g = x;
  } else if(hdash < 2.0) {
    *r = x;
    *g = chroma;
  } else if(hdash < 3.0) {
    *g = chroma;
    *b = x;
  } else if(hdash < 4.0) {
    *g = x;
    *b = chroma;
  } else if(hdash < 5.0) {
    *r = x;
    *b = chroma;
  } else if(hdash < 6.0) {
    *r = chroma;
    *b = x;
  }

  min = v - chroma;

  *r += min;
  *g += min;
  *b += min;
}


void Cell_Colormap(float val, float *red, float *green, float *blue)
{
  // Old [blue..red] palette:
  /*
   *red   = val;
   *green = 0;
   *blue  = 1.0f-val;
   */
  // OK Colors
  /*
   *blue  = cos(M_PI*val);
   *green = cos((M_PI)+ 2*M_PI*val);
   *red   = -cos(M_PI*val);
   */
  hsv_to_rgb(119.9f+ 240.0f*val, 1.0f, 1.0f, red, green, blue);
}
