#ifndef GUI_GAMEFRAME_C
#define GUI_GAMEFRAME_C

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/select.h>
#include <X11/Xlib.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <pthread.h>
#include <math.h> 
#include <signal.h>

#include "types.h"
#include "util.h"
#define GUI_WIDGET
#include "gui.h"
#undef GUI_WIDGET
#include "gui_util.h"
#include "gui_stats.h"

////////////////////////////////////////////////////////////////////////////////

int factorial(int x) {
  int i,fac=1;
 
  for (i=2; i<=x; i++) {
    fac *= i;
  }

  return fac;
}

int nchoosek(int n, int k)
{
  return (factorial(n) / factorial(n-k) / factorial(k));
}

static int D(gstate_t *st, int k, int n)
{
  float sum;
  int   i;

  // Base case
  if( n == 1 ) {
    if( k < st->K ) {
      return 1;
    } else {
      return 0;
    }
  }

  // For k < K
  if( k < st->K ) {
    return nchoosek(n+k-1,k);
  } 

  // For k >= K
  sum = 0;
  for(i=0; i<st->K; i++) {
    sum += D(st, k-i, n-1);
  }
  return sum;
}

static int C_k(gstate_t *st, int k)
{
  int N = 2*st->r+1;

  return D(st,k,N);
}


double calc_lambda_T(gstate_t *st)
{
  double ns;
  int i;
  for(ns=0.0,i=0; i<st->nrules; i++) {
    if( st->rules[i] == 0 ) {
      ns++;
    }
  }
  return (st->nrules-ns) / ((double)(st->nrules));
}


double calc_lambda(gstate_t *st)
{
  double ns;
  int i;
  for(ns=0.0,i=0; i<st->nrules; i++) {
    if( st->rules[i] == 0 ) {
      ns += C_k(st,i);
    }
  }
  return (pow(st->K,2*st->r+1) - ns) / pow(st->K,2*st->r+1);
}


double calc_H_T(gstate_t *st)
{
  double ns, ht = 0;
  int i, j;
  for(j=0; j<st->nrules; j++) {
    for(ns=0.0,i=0; i<st->nrules; i++) {
      if( st->rules[i] == j ) {
	ns++;
      }
    }
    ns /= st->nrules;
    if( ns ) {
      ht += ns * (log(ns)/log(2.0));
    }
  }
  return ht * -1.0;
}


double calc_H(gstate_t *st)
{
  double ns, ht = 0;
  int i, j;
  for(j=0; j<st->nrules; j++) {
    for(ns=0.0,i=0; i<st->nrules; i++) {
      if( st->rules[i] == j ) {
        ns += C_k(st,i);
      }
    }
    ns /= pow(st->K,2*st->r+1);
    if( ns ) {
      ht += ns * (log(ns)/log(2.0));
    }
  }
  return ht * -1.0;
}


void Stats_Draw(widget_t *w)
{
  //stats_gui_t *gf = (stats_gui_t*)w->wd;
  char  buf[1024];
  int   i;
	const int cols=4;
	float r,g,b;

  pthread_mutex_lock(&GuiLock);

  // Lambda_T
  Green();
  sprintf(buf,"lmbda_T: %.3lf", calc_lambda_T(Stateg));
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.10f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);

  // Lambda
  Green();
  sprintf(buf,"lmbda:   %.3lf", calc_lambda(Stateg));
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.15f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);

  // H_T
  Green();
  sprintf(buf,"H_T:     %.3lf",calc_H_T(Stateg));
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.20f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);

  // H 
  Green();
  sprintf(buf,"H:       %.3lf",calc_H(Stateg));
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.25f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);


  // Draw the rule table as well:
  sprintf(buf,"Rule Table:");
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.34f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);
  for(i=0; i<Stateg->nrules; i++) {
    glBegin(GL_QUADS);
    Cell_Colormap((float)i/Stateg->nrules, &r, &g, &b);
    glColor3f(r,g,b);

    glVertex2f(0.13f+0.2*(i%cols),        0.41f+0.05*((i/cols)-1));
    glVertex2f(0.13f+0.2*(i%cols),        0.41f+0.05*(i/cols));
    glVertex2f(0.13f+0.2*((i%cols)+1.0f), 0.41f+0.05*(i/cols));
    glVertex2f(0.13f+0.2*((i%cols)+1.0f), 0.41f+0.05*((i/cols)-1));
    glEnd();

    sprintf(buf,"%d",Stateg->rules[i]);
    Black();
    glRasterPos2f(0.15f + 0.2*(i%cols)  + 0.1      - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.41f + 0.05*(i/cols) - 0.05/2.0 + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
  }
  
  pthread_mutex_unlock(&GuiLock);

  // Outline
  Yellow();
  glBegin(GL_LINE_LOOP);
  glVertex2f(0.0f,0.0f);
  glVertex2f(0.0f,1.0f);
  glVertex2f(1.0f,1.0f);
  glVertex2f(1.0f,0.0f);
  glEnd();
}

#endif // !GUI_STATS_C
