#ifndef ONEDCASIM_H
#define ONEDCASIM_H

#include "types.h"
#include "random.h"
#include "history.h"

#define VERSION_STR "0.3.0"

typedef struct str_state_t {
  u64b_t      time;     // Time step / generation (may be clipped)
  rnd_t       random;   // Random number generator state
  int         rolling;  // Are we animating (scrolling) 
  history_t  *history;  // History for class detection
  int         nhistory; // Max entries in history

  int        *rules;  // Rule table
  int         nrules; // Entries in rule table

  int         cellsx; // Width of 1D cell torus
  int         cellsy; // Visual history / height (y axis is time)
  int       **cells;

  int         r;      // Radius
  int         K;      // Number of states per cell
  
  int         c_class;
  int         c_cycle;
  int         c_stride;
} state_t;


// Lets the GUI call back into the CA state
extern void set_state(int setup_rules);
extern void decimate();
extern int  run_state();

#endif


