#include <string.h>
#define GUI_WIDGET
#include "gui.h"
#include "gui_button.h"
#include "gui_util.h"
#include "gui_buttonsnn.h"
#include "gui_framenn.h"
#include "gui_statsnn.h"

#define LAYOUTNN_C
#include "layoutnn.h"

void LayoutWidgetsNN(glwindow_t *glw)
{
  static button_gui_t    bquit    = {"Quit",     0, 0, NULL};
  static button_gui_t    brand    = {"Random",   0, 0, NULL};
  static button_gui_t    bpattern = {"Pattern",  0, 0, NULL};
  static button_gui_t    bcont    = {"Continue", 0, 0, NULL};
  static button_gui_t    bdeci    = {"Decimate", 0, 0, NULL};
  static button_gui_t    beps     = {"Save EPS", 0, 0, NULL};
  static button_gui_t    bwrite   = {"Write Log",1, 0, NULL};
  static framenn_gui_t   gf;
  static stats_gui_t     stats;

  // Buttons
  AddWidget(glw, 768, 8,          128-8,  24, Button_Draw,  Quit_Key,     Quit_Down,     NULL, NULL, NULL,  &bquit);
  AddWidget(glw, 768, 8+(24+8),   128-8,  24, Button_Draw,  NULL,         Rand_Down,     NULL, NULL, NULL,  &brand);
  AddWidget(glw, 768, 8+(24+8)*2, 128-8,  24, Pattern_Draw, NULL,         Pattern_Down,  NULL, NULL, NULL,  &bpattern);
  AddWidget(glw, 768, 8+(24+8)*3, 128-8,  24, Button_Draw,  NULL,         Continue_Down, NULL, NULL, NULL,  &bcont);
  AddWidget(glw, 768, 8+(24+8)*4, 128-8,  24, Button_Draw,  NULL,         Decimate_Down, NULL, NULL, NULL,  &bdeci);
  AddWidget(glw, 768, 8+(24+8)*5, 128-8,  24, Button_Draw,  NULL,         EPS_Down,      NULL, NULL, NULL,  &beps);

  // Type Buttons 
  AddWidget(glw, 768, 24 + (24+8)*(0+6), 128-8, 24, Write_Draw, NULL, Write_Down, NULL, NULL, NULL,  &bwrite);

  // Status / info widget
  AddWidget(glw, 768, 24 + (24+8)*(7) + 16, 128-8, 768 - (24+(24+8)*(7)+16) - 8, Stats_Draw, NULL, NULL, NULL, NULL, NULL, &stats);

  // Main game frame
  memset(&gf,0,sizeof(gf));
  gf.text = "gf";
  AddWidget(glw, 8, 8, 768-16, 768-16, 
	    FrameNN_Draw, 
	    NULL, 
	    FrameNN_MouseDown, FrameNN_MouseUp, FrameNN_MouseMove,
	    NULL,
	    &gf);
}
