#ifndef GUI_STATSNN_C
#define GUI_STATSNN_C

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/select.h>
#include <X11/Xlib.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <pthread.h>
#include <math.h> 
#include <signal.h>

#include "types.h"
#include "util.h"
#define GUI_WIDGET
#include "gui.h"
#undef GUI_WIDGET
#include "gui_util.h"
#include "gui_statsnn.h"

////////////////////////////////////////////////////////////////////////////////

void Stats_Draw(widget_t *w)
{
  //stats_gui_t *gf = (stats_gui_t*)w->wd;
  char  buf[1024];


  pthread_mutex_lock(&GuiLock);

  // Step / generation
  Green();
  sprintf(buf,"Step: %llu",Stateg->time);
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.05f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);

  // Convergence data
  if( Stateg->converged == 0 ) {
    Red();
    sprintf(buf,"Unconverged");
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.45f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
  } else if( Stateg->converged == 1 ) {
    Green();
    sprintf(buf,"Converged");
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.45f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
    Yellow();
    sprintf(buf,"Calc Stats ...");
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.50f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
  } 
    
  pthread_mutex_unlock(&GuiLock);

  // Outline
  Yellow();
  glBegin(GL_LINE_LOOP);
  glVertex2f(0.0f,0.0f);
  glVertex2f(0.0f,1.0f);
  glVertex2f(1.0f,1.0f);
  glVertex2f(1.0f,0.0f);
  glEnd();
}

#endif // !GUI_STATS_C
