#ifndef GUI_STATS2D_C
#define GUI_STATS2D_C

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/select.h>
#include <X11/Xlib.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <pthread.h>
#include <math.h> 
#include <signal.h>

#include "types.h"
#include "util.h"
#define GUI_WIDGET
#include "gui.h"
#undef GUI_WIDGET
#include "gui_util.h"
#include "gui_stats2d.h"

////////////////////////////////////////////////////////////////////////////////

void Stats_Draw(widget_t *w)
{
  //stats_gui_t *gf = (stats_gui_t*)w->wd;
  char  buf[1024];


  pthread_mutex_lock(&GuiLock);

  // Step / generation
  Green();
  sprintf(buf,"Step: %llu",Stateg->time);
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.05f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);


  // CA rules
  Yellow();
  sprintf(buf,"r1:    %d",Stateg->r1);
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.15f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);

  sprintf(buf,"r2:    %d",Stateg->r2);
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.20f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);

  sprintf(buf,"j1: %.3lf",Stateg->j1);
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.25f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);

  sprintf(buf,"j2: %.3lf",Stateg->j2);
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.30f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);

  sprintf(buf,"h:  %.3lf",Stateg->hv);
  glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		0.35f + 4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",buf);


  // Convergence data
  if( Stateg->converged == 0 ) {
    Red();
    sprintf(buf,"Unconverged");
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.45f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
  } else if( Stateg->converged == 1 ) {
    Green();
    sprintf(buf,"Converged");
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.45f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
    Yellow();
    sprintf(buf,"Calc Stats ...");
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.50f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
  } else if( Stateg->converged == 2 ) {
    Green();
    sprintf(buf,"Converged");
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.45f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
    Yellow();
    sprintf(buf,"Ch.Len:  %d    ",Stateg->characteristic_correlation_len);
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.50f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
    Yellow();
    sprintf(buf,"SC_L:   %0.4f",
	    Stateg->spatial_correlation[Stateg->characteristic_correlation_len]);
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.55f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
    Yellow();
    sprintf(buf,"H_L:    %0.4f",
	    Stateg->joint_entropy[Stateg->characteristic_correlation_len]);
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.60f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
    Yellow();
    sprintf(buf,"I_L:    %0.4f",
	    Stateg->mutual_information[Stateg->characteristic_correlation_len]);
    glRasterPos2f(0.03f + 0.5 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
		  0.65f + 4.0f/ScaleY(w,w->h));
    printGLf(w->glw->font,"%s",buf);
  }
    
  pthread_mutex_unlock(&GuiLock);

  // Outline
  Yellow();
  glBegin(GL_LINE_LOOP);
  glVertex2f(0.0f,0.0f);
  glVertex2f(0.0f,1.0f);
  glVertex2f(1.0f,1.0f);
  glVertex2f(1.0f,0.0f);
  glEnd();
}

#endif // !GUI_STATS_C
