#ifndef GUI_FRAMENN_H
#define GUI_FRAMENN_H


////////////////////////////////////////////////////////////
// For all files

#include "types.h"

typedef struct {
  char       *text;     // Text drawn on frame2d
  u32b_t      val;      // Frame2d value
  u8b_t       sel;      // 1 == selected, 0 == not selected
  u32b_t     *link;     // A pointer link to an int controlled by this frame2d
  u32b_t      md;       // Mouse down flags
  u32b_t      mdx;      // Mouse x-axis coordinate when mouse went down
  u32b_t      mdy;      // Mouse y-axis coordinate when mouse went down
  float       rotx;     // Rotation around x-axis
  float       roty;     // Rotation around y-axis
  float       zoom;     // Zoom into the origin
} framenn_gui_t;


////////////////////////////////////////////////////////////
// For files other than gui_framenn.c
#ifndef GUI_FRAMENN_C
extern void FrameNN_Draw(widget_t *w);
extern void FrameNN_MouseDown(widget_t *w, int x, int y, int b);
extern void FrameNN_MouseUp  (widget_t *w, int x, int y, int b);
extern void FrameNN_MouseMove(widget_t *w, int x, int y);
#endif


#endif // !GUI_FRAMENN_H
