#ifndef GUI_FRAMENN_C
#define GUI_FRAMENN_C

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/select.h>
#include <X11/Xlib.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <pthread.h>
#include <math.h> 
#include <signal.h>

#include "types.h"
#include "casimnn.h"
#include "util.h"
#include "params.h"
#define GUI_WIDGET
#include "gui.h"
#undef GUI_WIDGET
#include "gui_util.h"
#include "gui_framenn.h"

extern int pattern;

////////////////////////////////////////////////////////////////////////////////

// Button callbacks

void FrameNN_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
  }
}

////////////////////////////////////////////////////////////////////////////////


void FrameNN_Draw(widget_t *w)
{
  framenn_gui_t *gf = (framenn_gui_t*)w->wd;
  int            i,j,x,y;
  char           buf[1024];

  // RLE
  int lastc=0;
  int lastx=0;
  int c = 0;

  float cx = (float)Stateg->w;
  float cy = (float)Stateg->h;

  glBegin(GL_QUADS);

  for(y=0; y<cy; y++) {
    // Initialize first run
    lastx=0;
    lastc=Stateg->cells[y][0];

    for(x=0; x<=cx; x++) {
      if (x != cx ) {
        c = Stateg->cells[y][x];
      }
      // Draw last run if change or EOL
      if (c != lastc || x==cx) {
        if( (lastc == 1) || (lastc == -1) ) {
          //Cell_Colormap((lastc/((float)Stateg->K-1)), &r, &g, &b);
	  if( lastc == 1 ) {
	    glColor3f(1.0f,0.0f,0.0f);
	  } else if( lastc == -1 ) {
	    glColor3f(0.0f,0.0f,1.0f);
	  } else {
	    glColor3f(0.0f,1.0f,0.0f);
	  }
          glVertex2f((lastx)/cx, (y)/cy);
          glVertex2f((lastx)/cx, (y+1)/cy);
          glVertex2f((x)/cx,   (y+1)/cy);
          glVertex2f((x)/cx,   (y)/cy);
        }
        lastc = c;
        lastx = x;
      }
    }
  }

  glEnd();

  // Outline
  Yellow();
  glBegin(GL_LINE_LOOP);
  glVertex2f(0.0f,0.0f);
  glVertex2f(0.0f,1.0f);
  glVertex2f(1.0f,1.0f);
  glVertex2f(1.0f,0.0f);
  glEnd();

  // Hover box
  if( gf->md == MOUSE_LEFT ) {
    // Write mode
    x = (ScaleX(w, gf->mdx) / ScaleX(w, w->w)) * Stateg->w;
    y = (ScaleY(w, gf->mdy) / ScaleY(w, w->h)) * Stateg->h;
    if( (x > 0) && (x < Stateg->w) && (y > 0) && (y < Stateg->h) ) {
      write_cell(x,y,1);
      pattern = -1;
    }
  } else if( gf->md == MOUSE_RIGHT ) {
    // Erase mode
    x = (ScaleX(w, gf->mdx) / ScaleX(w, w->w)) * Stateg->w;
    y = (ScaleY(w, gf->mdy) / ScaleY(w, w->h)) * Stateg->h;
    if( (x > 0) && (x < Stateg->w) && (y > 0) && (y < Stateg->h) ) {
      write_cell(x,y,-1);
      pattern = -1;
    }
  }
}

void FrameNN_MouseDown(widget_t *w, int x, int y, int b)
{
  framenn_gui_t *gf = (framenn_gui_t*)w->wd;

  // Check bounds
  if( (x >= ScaleX(w, w->x)) && (x <= ScaleX(w, w->x+w->w)) && 
      (y >= ScaleY(w, w->y)) && (y <= ScaleY(w, w->y+w->h))    ) {
    switch(b) {
    case MOUSE_UP:
      break;
    case MOUSE_DOWN:
      break;
    case MOUSE_LEFT:
      gf->mdx = x;     
      gf->mdy = y; 
      break;
    }
    gf->md = b;
  }
}

void FrameNN_MouseUp(widget_t *w, int x, int y, int b)
{
  framenn_gui_t *gf = (framenn_gui_t*)w->wd;

  // Record that the mouse is now up
  if( gf->md == b ) {
    gf->md = 0;
  }
}

void FrameNN_MouseMove(widget_t *w, int x, int y)
{
  framenn_gui_t *gf = (framenn_gui_t*)w->wd;

  gf->mdx = x;  
  gf->mdy = y; 
}


#endif // !GUI_FRAMENN_C
