#ifndef GUI_FRAME1D_H
#define GUI_FRAME1D_H


////////////////////////////////////////////////////////////
// For all files

#define GGF_KILL_TIME       (200.0f)
#define GGF_KILL_LIGHT_TIME (100.0f)
#define GGF_FIRE_TIME       (14.0f)
#define GGF_FIRE_LIGHT_TIME (14.0f)

#define GGF_GEM_SLICES 16
#define GGF_GEM_STACKS 16

#include "types.h"
#define GUI_WIDGET
#include "gui.h"

typedef struct {
  char       *text;     // Text drawn on frame1d
  u32b_t      val;      // frame1d value
  u8b_t       sel;      // 1 == selected, 0 == not selected
  u32b_t     *link;     // A pointer link to an int controlled by this frame1d
  u32b_t      md;       // Mouse down flags
  u32b_t      mdx;      // Mouse x-axis coordinate when mouse went down
  u32b_t      mdy;      // Mouse y-axis coordinate when mouse went down
  float       rotx;     // Rotation around x-axis
  float       roty;     // Rotation around y-axis
  float       zoom;     // Zoom into the origin
} frame1d_gui_t;


////////////////////////////////////////////////////////////
// For files other than gui_frame1d.c
#ifndef GUI_FRAME1D_C
extern void frame1d_Draw(widget_t *w);
extern void frame1d_MouseDown(widget_t *w, int x, int y, int b);
extern void frame1d_MouseUp(widget_t *w, int x, int y, int b);
extern void frame1d_MouseMove(widget_t *w, int x, int y);
#endif


#endif // !GUI_FRAME1D_H
