#ifndef GUI_FRAME1D_C
#define GUI_FRAME1D_C

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/select.h>
#include <X11/Xlib.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <pthread.h>
#include <math.h> 
#include <signal.h>

#include "types.h"
#include "util.h"
#include "params.h"
#define GUI_WIDGET
#include "gui.h"
#undef GUI_WIDGET
#include "gui_util.h"
#include "gui_frame1d.h"

////////////////////////////////////////////////////////////////////////////////

// Button callbacks

void frame1d_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
  }
}

////////////////////////////////////////////////////////////////////////////////


void frame1d_Draw(widget_t *w)
{
  frame1d_gui_t *gf = (frame1d_gui_t*)w->wd;
  int              i,j,x,y;
  float            r,g,b;
  char             buf[1024];

  // RLE
	int lastc=0;
	int lastx=0;
  int c = 0;

  float cx = (float)Stateg->cellsx;
  float cy = (float)Stateg->cellsy;

  glBegin(GL_QUADS);


  for(y=0; y<cy; y++) {
    // Initialize first run
    lastx=0;
    lastc=Stateg->cells[y][0];

    for(x=0; x<=cx; x++) {
      if (x != cx ) {
        c = Stateg->cells[y][x];
      }
      // Draw last run if change or EOL
      if (c != lastc || x==cx) {
        if (lastc) {
          Cell_Colormap((lastc/((float)Stateg->K-1)), &r, &g, &b);
          glColor3f(r,g,b);
          glVertex2f((lastx)/cx, (y)/cy);
          glVertex2f((lastx)/cx, (y+1)/cy);
          glVertex2f((x)/cx,   (y+1)/cy);
          glVertex2f((x)/cx,   (y)/cy);
        }
        lastc = c;
        lastx = x;
      }
    }
  }

  glEnd();

  // Outline
  Yellow();
  glBegin(GL_LINE_LOOP);
  glVertex2f(0.0f,0.0f);
  glVertex2f(0.0f,1.0f);
  glVertex2f(1.0f,1.0f);
  glVertex2f(1.0f,0.0f);
  glEnd();

  // Hover box
  if( gf->md == MOUSE_LEFT ) {
    // Compute some nice sizes / positions
    float bw,bh;
    float mx,my;
    int   br;

    br = 6;
    bw = 0.25;
    bh = 0.25;
    mx = (gf->mdx-ScaleX(w,w->x)) / ScaleX(w,w->w);
    my = (gf->mdy-ScaleY(w,w->y)) / ScaleY(w,w->h);

    // Translate to the center where the mouse is
    glPushMatrix();
    glTranslatef( mx - bw/2, 
		  my - bh/2,
		  0.0f);
    // Draw the hover box contents
    Black();
    glBegin(GL_QUADS);
    glVertex2f(0.0f, 0.0f);
    glVertex2f(0.0f, bh);
    glVertex2f(bw,   bh);
    glVertex2f(bw,   0.0f);
    glEnd();
    x = mx * Stateg->cellsx;
    y = my * Stateg->cellsy;
    for(i=-br; i<=br; i++) {
      for(j=-br; j<=br; j++) {
	if( (y+i >= 0) && (y+i < Stateg->cellsy) &&
	    (x+j >= 0) && (x+j < Stateg->cellsx)    ) {
	  if( Stateg->cells[y+i][x+j] ) {
	    Cell_Colormap(Stateg->cells[y+i][x+j]/((float)Stateg->K-1), &r, &g, &b);
	    glColor3f(r,g,b);
	    glBegin(GL_QUADS);
	    glVertex2f((j+br)*bw/(br*2+1),             (i+br)*bh/(br*2+1));
	    glVertex2f((j+br)*bw/(br*2+1),             (i+br)*bh/(br*2+1)+bh/(br*2+1));
	    glVertex2f((j+br)*bw/(br*2+1)+bw/(br*2+1), (i+br)*bh/(br*2+1)+bh/(br*2+1));
	    glVertex2f((j+br)*bw/(br*2+1)+bw/(br*2+1), (i+br)*bh/(br*2+1));
	    glEnd();
	    Black();
	    sprintf(buf,"%d",Stateg->cells[y+i][x+j]);
	    Black();
	    glRasterPos2f((j+br)*bw/(br*2+1)   + bw/(br*2+1)/2 - ((strlen(buf)*6.0f/2.0f)/ScaleX(w,w->w)),
			  (i+br+1)*bh/(br*2+1) - bh/(br*2+1)/2 + 4.0f/ScaleY(w,w->h));
	    printGLf(w->glw->font,"%s",buf);
	  }
	}
      }
    }
    // Draw the hover box outline
    Yellow();
    glBegin(GL_LINE_LOOP);
    glVertex2f(0.0f, 0.0f);
    glVertex2f(0.0f, bh);
    glVertex2f(bw,   bh);
    glVertex2f(bw,   0.0f);
    glEnd();
    // Undo mouse-centric position
    glPopMatrix();
  }
}

void frame1d_MouseDown(widget_t *w, int x, int y, int b)
{
  frame1d_gui_t *gf = (frame1d_gui_t*)w->wd;

  // Check bounds
  if( (x >= ScaleX(w, w->x)) && (x <= ScaleX(w, w->x+w->w)) && 
      (y >= ScaleY(w, w->y)) && (y <= ScaleY(w, w->y+w->h))    ) {
    switch(b) {
    case MOUSE_UP:
      break;
    case MOUSE_DOWN:
      break;
    case MOUSE_LEFT:
      gf->mdx = x;     
      gf->mdy = y; 
      break;
    }
    gf->md = b;
  }
}

void frame1d_MouseUp(widget_t *w, int x, int y, int b)
{
  frame1d_gui_t *gf = (frame1d_gui_t*)w->wd;

  // Record that the mouse is now up
  if( gf->md == b ) {
    gf->md = 0;
  }
}

void frame1d_MouseMove(widget_t *w, int x, int y)
{
  frame1d_gui_t *gf = (frame1d_gui_t*)w->wd;

  gf->mdx = x;  
  gf->mdy = y; 
}


#endif // !GUI_FRAME1D_C
