#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "casim1d.h"
#include "ps.h"
#include "gui_util.h"
#define GUI_WIDGET
#include "gui.h"
#include "gui_button.h"
#include "gui_stats1d.h"
#include "gui_buttons1d.h"

// Button callbacks + helpers
void print_class(int c)
{
  int i, n = Stateg->nrules;
  printf("(");
  for (i=0; i<n; ++i) {
    printf("%d%c", Stateg->rules[i], i==n-1?')':',');
  }
  printf(" %d %d", Stateg->r, Stateg->K); 
  printf(" %.6lf %.6lf %.6lf %.6lf %.6lf ",
	 calc_lambda_T(Stateg), 
	 calc_lambda(Stateg),
	 calc_H_T(Stateg), 
	 calc_H(Stateg),
	 calc_psi(Stateg));
  printf("%d\n", c);
  fflush(stdout);
}


void EPS_Down(widget_t *w, const int x, const int y, const int b)
{
  static int  ss=0;
  char        fn[1024],buf[1024];
  FILE       *f;
  float       rd,gr,bl;
  int         i,j;

  // RLE
  int lastc;
  int lastj;
  int c = 0;

  int cx = (float)Stateg->cellsx;
  int cy = (float)Stateg->cellsy;

  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    // Generate a filename from the rule table
    sprintf(fn,"r-%d-K-%d-w-%d-h-%d-rules--",
        Stateg->r,
        Stateg->K,
        cx,
        cy );
    for (i=0; i<Stateg->nrules; ++i) {
      sprintf(buf,"%d-",Stateg->rules[i]);
      strcat(fn, buf);
    }
    sprintf(buf,"-%d.eps",ss);
    ss++;
    strcat(fn, buf);

    // Renter EPS
    f = PS_Start(fn, 8.0, 8.0);
    sprintf(buf,"1dcasim_hdr:%s",fn);
    PS_Ccomment(f, buf);
    PS_Color(f, 
        0.0f,
        0.0f, 
        0.0f);
    PS_Quad(f,
        0.0, 0.0,
        8.0, 0.0,
        8.0, 8.0,
        0.0, 8.0,
        1);

    for(i=0; i<cy; i++) {
      // Initialize first run
      lastj=0;
      lastc=Stateg->cells[i][0];

      for(j=0; j<=cx; j++) {
        // Adopt color if not past last cell
        if (j !=cx) {
          c = Stateg->cells[i][j];

          // Always print comment for any live cell
          if( c ) {
            sprintf(buf,"1dcasim_cell:%d,%d:%d", j, i, c);
            PS_Ccomment(f, buf);
          }
        }
        // Draw last run if change or EOL
        if (c != lastc || j==cx) {
          if (lastc) {
            Cell_Colormap((lastc/((float)Stateg->K-1)), &rd, &gr, &bl);
            PS_Color(f, rd, gr, bl);
            PS_Quad(f,
                ((float)lastj)/cx*8, ((float)i)  /cy*8,
                ((float)lastj)/cx*8, ((float)i+1)/cy*8,
                ((float)j)/cx*8,     ((float)i+1)/cy*8,
                ((float)j)/cx*8,     ((float)i)  /cy*8,
                1);
          }
          lastc = c;
          lastj = j;
        }
      }
    }

    PS_End(f);
  }
}

void Quit_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    GuiExit();
  }
}


// Regenerates CA
void Rand_CA_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    set_state(1);
  }
}

// Regenerates initial state and runs
void Restart_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    set_state(0); // Keep rules
  }
}

// Continue...
void Continue_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    button_gui_t *btn = (button_gui_t*)(w->wd);
    btn->sel = run_state();
  }
}


// Decimates, then re-runs
void Decimate_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    decimate();
    set_state(0); // Keep rules
  }
}

void Class_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {

    button_gui_t *btn = (button_gui_t*)w->wd;
    int   c     = btn->val;

    print_class(c);
  }
}


////////////////////////////////////////////////////////////////////////////////

// Key press callbacks

void Quit_Key(widget_t *w, char key, unsigned int keycode)
{
  if (key=='q') { GuiExit(); }
}

void Rand_CA_Key(widget_t *w, char key, unsigned int keycode)
{
  if (key=='a') { set_state(1); }
}

void Restart_Key(widget_t *w, char key, unsigned int keycode)
{
  if (key=='s') { set_state(0); } // Keep rules
}

void Continue_Key(widget_t *w, char key, unsigned int keycode)
{
  if (key=='c') {
    button_gui_t *btn = (button_gui_t*)(w->wd);
    btn->sel = run_state();
  }
}

void Decimate_Key(widget_t *w, char key, unsigned int keycode)
{
  if (key=='d') {
    decimate();
    set_state(0); // Keep rules
  }
}

void Class_Key(widget_t *w, char key, unsigned int keycode)
{
  button_gui_t *btn = (button_gui_t*)w->wd;
  int c = btn->val;

  if (key >= '1' && key <= '4') {
    int kval = 1 + (key-'1');
    if (kval == c) {
      print_class(c);
    }
  }
}

////////////////////////////////////////////////////////////////////////////////


// Tick callbacks
void ClassI_Tick(widget_t *w)
{
  button_gui_t *b=(button_gui_t*)w->wd;
  pthread_mutex_lock(&GuiLock);
  b->sel = (Stateg->c_type == 1);
  pthread_mutex_unlock(&GuiLock);
}


void ClassII_Tick(widget_t *w)
{
  button_gui_t *b=(button_gui_t*)w->wd;
  pthread_mutex_lock(&GuiLock);
  b->sel = (Stateg->c_type == 2);
  pthread_mutex_unlock(&GuiLock);
}

////////////////////////////////////////////////////////////////////////////////
