#ifndef CASIMNN_H
#define CASIMNN_H

#include "types.h"
#include "random.h"

#define VERSION_STR "0.0.6"

typedef struct str_state_t {
  u64b_t      time;     // Time step / generation (may be clipped)
  rnd_t       random;   // Random number generator state
  int         rolling;  // Are we animating (scrolling in time) 
  int         bch;      // Are we no GUI fast batch only?

 
  int       **cells;    // Cells / neurons
  int         w;
  int         h;

  float     **W;        // Neuronal connection weight matrix

  int       **patterns; // Patterns stored in the W matrix
  int         npatterns;

  int         converged; // 1 iff converged
} state_t;


// Lets the GUI call back into the CA state
extern void set_state();
extern void decimate();
extern int  run_state();
extern void set_pattern(int *pattern);
extern void write_call(int x, int y, int v);

#endif


