#ifndef CASIM2D_H
#define CASIM2D_H

#include "types.h"
#include "random.h"

#define VERSION_STR "0.0.5"

typedef struct str_state_t {
  u64b_t      time;     // Time step / generation (may be clipped)
  rnd_t       random;   // Random number generator state
  int         rolling;  // Are we animating (scrolling in time) 
  int         bch;      // Are we no GUI fast batch only?

  int         cellsx;   // Width of 1D cell torus
  int         cellsy;   // Visual history / height (y axis is time)
  int       **cells;
  int         w;
  int         h;


  float       hv;        // Constant bias
  int         r1;        // Radius1 (promotional)
  int         r2;        // Radius2 (inhibitory)
  float       j1;        // Scales radius 1 sum
  float       j2;        // Scales radium 2 sum

  int         converged; // 1 iff converged

  int         maxlen;
  int         characteristic_correlation_len;
  float      *spatial_correlation;
  float      *joint_entropy;
  float      *mutual_information;
} state_t;


// Lets the GUI call back into the CA state
extern void set_state(int n);
extern void decimate();
extern int  run_state();

#endif


