#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "params.h"
#include "casim2d.h"
#define STATS2D_C
#include "stats2d.h"

////////////////////////////////////////////////////////////////////////////////

static inline void indexmap(state_t *st, int x, int y, int *nx, int *ny)
{
  int i;

  i = x;
  // Catch the case where i is too small
  while( i < 0 ) {
    i = st->w + i;
  }
  // Catch the case where i is too large
  while( i >= st->w ) {
    i = i - st->w;
  }
  // Record
  *nx = i;

  i = y;
  // Catch the case where i is too small
  while( i < 0 ) {
    i = st->h + i;
  }
  // Catch the case where i is too large
  while( i >= st->h ) {
    i = i - st->h;
  }
  // Record
  *ny = i;
}

////////////////////////////////////////////////////////////////////////////////

static float sq_scale_sum_cells(state_t *st)
{
  float sum;
  float scale;
  int i,j;

  // Compute the sum of all cells
  sum = 0.0f;
  for(i=0; i<st->h; i++) {
    for(j=0; j<st->w; j++) {
      sum += st->cells[i][j];
    }
  }

  // Scale by the number of cells
  scale = 1.0f / (st->w * st->h);

  // Return the square of the scaled sum of the cells
  return (sum*scale)*(sum*scale);
}

float stats2d_p(state_t *st, int d)
{
  float scale;
  int   i,j,k,y,x,sum0,sum1;

  // Base case
  if( !d ) {
    return 1.0f - sq_scale_sum_cells(st);
    //return 1.0f;
  }

  // Compute the scale factor for sum0
  scale = 1.0f / (4*d*st->w*st->h);
  
  // Compute sum0
  sum0 = 0;
  for(i=0; i<st->h; i++) {
    for(j=0; j<st->w; j++) {
      // Compute sum1
      sum1 = 0;

      for(k=-d; k<=d; k++) {
	if( abs(k) != abs(d) ) {
	  x = j + k;
	  y = +(d-abs(k))+i;
	  indexmap(st, x, y, &x, &y);	
	  sum1 += st->cells[y][x];	
	}
	
	x = j + k;
	y = -(d-abs(k))+i;
	indexmap(st, x, y, &x, &y);	
	sum1 += st->cells[y][x];
      }

      // Comtribute to sum0
      sum0 += st->cells[i][j] * sum1;
    }
  }

  // Return the final absolute spatial corelation at distance d
  return fabs( sum0*scale - sq_scale_sum_cells(st) );
}

////////////////////////////////////////////////////////////////////////////////

float stats2d_H(state_t *st, int d)
{
  float prpp,prmm,prpm,prmp,H;
  int   i,j,k,x,y,sum;
  
  if( !d ) {
    return 0.0f; // !!av ?
  }

  // Compute prpp
  sum = 0.0; 
  for(i=0; i<st->h; i++) {
    for(j=0; j<st->w; j++) {
      for(k=-d; k<=d; k++) {
	if( abs(k) != abs(d) ) {
	  x = j + k;
	  y = +(d-abs(k))+i;
	  indexmap(st, x, y, &x, &y);	
	  sum += ((st->cells[y][x]+1)/2) * ((st->cells[i][j]+1)/2);	
	}

	x = j + k;
	y = -(d-abs(k))+i;
	indexmap(st, x, y, &x, &y);	
	sum += ((st->cells[y][x]+1)/2) * ((st->cells[i][j]+1)/2);
      }
    }
  }
  // !!av: prpp = (2.0f * sum) / (((double)(st->w*st->h))*(4*d));
  prpp = sum / (((double)(st->w*st->h))*(4*d));

  // Compute prmm
  sum = 0.0;
  for(i=0; i<st->h; i++) {
    for(j=0; j<st->w; j++) {
      for(k=-d; k<=d; k++) {
	if( abs(k) != abs(d) ) {
	  x = j + k;
	  y = +(d-abs(k))+i;
	  indexmap(st, x, y, &x, &y);	
	  sum += ((st->cells[y][x]*(-1)+1)/2) * ((st->cells[i][j]*(-1)+1)/2);	
	}

	x = j + k;
	y = -(d-abs(k))+i;
	indexmap(st, x, y, &x, &y);	
	sum += ((st->cells[y][x]*(-1)+1)/2) * ((st->cells[i][j]*(-1)+1)/2);
      }
    }
  }
  prmm = sum / (((double)(st->w*st->h))*(4*d));

  // Compute prpm and prmp
  prpm = prmp = 1.0f - prmm - prpp;

  // Turn these probabilities into entropy
  H = -( ((prpp>0)?(prpp*log(prpp)):(0.0f)) + 
	 ((prmm>0)?(prmm*log(prmm)):(0.0f)) + 
	 ((prpm>0)?(prpm*log(prpm)):(0.0f))   );
  
  return H;
}

static float H_S(state_t *st)
{
  float prp1,prm1,H;
  int   i,j,sum;

  // Compute sum where cell[i][i] is in [0,1]
  sum = 0;
  for(i=0; i<st->h; i++) {
    for(j=0; j<st->w; j++) {
      sum += (st->cells[i][j]+1)/2;
    }
  }

  // Compute entropy
  prp1 = ((float)sum) / (st->w*st->h);
 
  prm1 = 1.0f - prp1;
  H = -( ((prp1>0)?(prp1*log(prp1)):(0.0f)) + 
	 ((prm1>0)?(prm1*log(prm1)):(0.0f))   );
  
  return H;
}

float stats2d_I(state_t *st, int d)
{
  return 2.0f*H_S(st) - stats2d_H(st,d);
}

////////////////////////////////////////////////////////////////////////////////

