#include <string.h>
#define GUI_WIDGET
#include "gui.h"
#include "gui_button.h"
#include "gui_util.h"
#include "gui_buttons2d.h"
#include "gui_frame2d.h"
#include "gui_stats2d.h"

#define LAYOUT2D_C
#include "layout2d.h"

void LayoutWidgets2D(glwindow_t *glw)
{
  static button_gui_t    bquit    = {"Quit",     0, 0, NULL};
  static button_gui_t    brand_ca = {"Random CA",0, 0, NULL};
  static button_gui_t    brestart = {"Restart",  0, 0, NULL};
  static button_gui_t    bcont    = {"Continue", 0, 0, NULL};
  static button_gui_t    bdeci    = {"Decimate", 0, 0, NULL};
  static button_gui_t    beps     = {"Save EPS", 0, 0, NULL};
  static button_gui_t    bclass   = {"Write Log",1, 0, NULL};
  static frame2d_gui_t gf;
  static stats_gui_t   stats;

  // Buttons
  AddWidget(glw, 768, 8,          128-8,  24, Button_Draw,  Quit_Key,     Quit_Down,     NULL, NULL, NULL,  &bquit);
  AddWidget(glw, 768, 8+(24+8),   128-8,  24, Button_Draw,  NULL,         Rand_CA_Down,  NULL, NULL, NULL,  &brand_ca);
  AddWidget(glw, 768, 8+(24+8)*2, 128-8,  24, Button_Draw,  NULL,         Restart_Down,  NULL, NULL, NULL,  &brestart);
  AddWidget(glw, 768, 8+(24+8)*3, 128-8,  24, Button_Draw,  NULL,         Continue_Down, NULL, NULL, NULL,  &bcont);
  AddWidget(glw, 768, 8+(24+8)*4, 128-8,  24, Button_Draw,  NULL,         Decimate_Down, NULL, NULL, NULL,  &bdeci);
  AddWidget(glw, 768, 8+(24+8)*5, 128-8,  24, Button_Draw,  NULL,         EPS_Down,      NULL, NULL, NULL,  &beps);

  // Type Buttons 
  AddWidget(glw, 768, 24 + (24+8)*(0+6), 128-8, 24, Write_Draw, NULL, Write_Down, NULL, NULL, NULL,  &bclass);

  // Status / info widget
  AddWidget(glw, 768, 24 + (24+8)*(7) + 16, 128-8, 768 - (24+(24+8)*(7)+16) - 8, Stats_Draw, NULL, NULL, NULL, NULL, NULL, &stats);

  // Main game frame
  memset(&gf,0,sizeof(gf));
  gf.text = "gf";
  AddWidget(glw, 8, 8, 768-16, 768-16, 
	    Frame2d_Draw, 
	    NULL, 
	    Frame2d_MouseDown, Frame2d_MouseUp, Frame2d_MouseMove,
	    NULL,
	    &gf);
}
