#include <string.h>
#define GUI_WIDGET
#include "gui.h"
#include "gui_button.h"
#include "gui_buttons1d.h"
#include "gui_frame1d.h"
#include "gui_stats1d.h"
#include "gui_util.h"

#define LAYOUT1D_C
#include "layout1d.h"

void LayoutWidgets1D(glwindow_t *glw)
{
  static button_gui_t    bquit    = {"Quit",     0, 0, NULL};
  static button_gui_t    brand_ca = {"Random CA",0, 0, NULL};
  static button_gui_t    brestart = {"Restart",  0, 0, NULL};
  static button_gui_t    bcont    = {"Continue", 0, 0, NULL};
  static button_gui_t    bdeci    = {"Decimate", 0, 0, NULL};
  static button_gui_t    beps     = {"Save EPS", 0, 0, NULL};
  static button_gui_t    bclasses[4] = {
                                  {"Class I",  1, 0, NULL},
                                  {"Class II", 2, 0, NULL},
                                  {"Class III",3, 0, NULL},
                                  {"Class IV", 4, 0, NULL} };
  static frame1d_gui_t gf;
  static stats_gui_t   stats;

  // Buttons
  AddWidget(glw, 768, 8,          128-8,  24, Button_Draw,  Quit_Key,     Quit_Down,     NULL, NULL, NULL,  &bquit);
  AddWidget(glw, 768, 8+(24+8),   128-8,  24, Button_Draw,  Rand_CA_Key,  Rand_CA_Down,  NULL, NULL, NULL,  &brand_ca);
  AddWidget(glw, 768, 8+(24+8)*2, 128-8,  24, Button_Draw,  Restart_Key,  Restart_Down,  NULL, NULL, NULL,  &brestart);
  AddWidget(glw, 768, 8+(24+8)*3, 128-8,  24, Button_Draw,  Continue_Key, Continue_Down, NULL, NULL, NULL,  &bcont);
  AddWidget(glw, 768, 8+(24+8)*4, 128-8,  24, Button_Draw,  Decimate_Key, Decimate_Down, NULL, NULL, NULL,  &bdeci);
  AddWidget(glw, 768, 8+(24+8)*5, 128-8,  24, Button_Draw,  NULL,         EPS_Down,      NULL, NULL, NULL,  &beps);

  // Type Buttons 
  AddWidget(glw, 768, 24 + (24+8)*(0+6), 128-8, 24, Button_Draw, Class_Key, Class_Down, NULL, NULL, ClassI_Tick,  &bclasses[0]);
  AddWidget(glw, 768, 24 + (24+8)*(1+6), 128-8, 24, Button_Draw, Class_Key, Class_Down, NULL, NULL, ClassII_Tick, &bclasses[1]);
  AddWidget(glw, 768, 24 + (24+8)*(2+6), 128-8, 24, Button_Draw, Class_Key, Class_Down, NULL, NULL, NULL,         &bclasses[2]);
  AddWidget(glw, 768, 24 + (24+8)*(3+6), 128-8, 24, Button_Draw, Class_Key, Class_Down, NULL, NULL, NULL,         &bclasses[3]);


  // Status / info widget
  AddWidget(glw, 768, (768-16)/2, 128-8, 768-8-(768-16)/2, Stats_Draw, NULL, NULL, NULL, NULL, NULL, &stats);

  // Main game frame
  memset(&gf,0,sizeof(gf));
  gf.text = "gf";
  AddWidget(glw, 8, 8, 768-16, 768-16, 
	    frame1d_Draw, 
	    NULL, 
	    frame1d_MouseDown, frame1d_MouseUp, frame1d_MouseMove,
	    NULL,
	    &gf);
}
