#include <malloc.h>
#include <string.h>

#include "params.h"
#include "history1d.h"

long history_descr(int* cells, int ncells)
{
  int i, descr=0;
  for (i=0; i<ncells; ++i) {
    descr += cells[i];
  }
  return descr;
}

void history_free(history_t *h)
{
  history_t *p;
  while(h) {
    p = h->prev;
    free(h->cells);
    free(h);
    h = p;
  }
}

history_t* history_create(int* cells, int ncells, history_t* prev)
{
  history_t *h = (history_t*)malloc(sizeof(history_t));
  h->descr = history_descr(cells, ncells);
  h->prev  = prev;
  h->cells = (int*)malloc(ncells*sizeof(int));
  memcpy(h->cells, cells, ncells*sizeof(int));

  return h;
}


// Returns translation offset if equal, -1 otherwise
int history_compare(history_t *h0, history_t *h1, int len) {
	int i,j;
	int *c0=h0->cells;
	int *c1=h1->cells;

	if (h0->descr != h1->descr) {
		return -1;
	} else {
		// Loop over possible translations
		for (i=0; i<len; ++i) {
			if (c0[0] == c1[i]) {
				// Wrapped string compare
				for(j=0; j<len; ++j) {
					if (c0[j] !=c1[(i+j)%len]) {
						// Bogus attempt
						break;
					}
				}
				if (j==len) {
					// Yes! it worked.
					return i;
				}
			}
		}
	}
	return -1;
}

