#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "casim2d.h"
#include "io_eps2d.h"
#include "gui_util.h"
#define GUI_WIDGET
#include "gui.h"
#include "gui_button.h"
#include "gui_stats2d.h"
#include "gui_buttons2d.h"


void EPS_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    // Write the current state to an auto named ouptu file
    io_epsfromstate((state_t*)Stateg, NULL, 8.0f, 8.0f);
  }
}

void Quit_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    GuiExit();
  }
}


// Regenerates CA
void Rand_CA_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    set_state(1); // genereate new rules
  }
}

// Regenerates initial state and runs
void Restart_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    set_state(0); // Keep rules
  }
}

// Continue...
void Continue_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    button_gui_t *btn = (button_gui_t*)(w->wd);
    btn->sel = run_state();
  }
}


// Decimates, then re-runs
void Decimate_Down(widget_t *w, const int x, const int y, const int b)
{
  if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
      (y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
    decimate();
    set_state(0); // Keep rules
  }
}

////////////////////////////////////////////////////////////////////////////////

void Write_Down(widget_t *w, const int x, const int y, const int b)
{
  //button_gui_t *b=(button_gui_t*)w->wd;
  int i,maxlen;

  if( Stateg->converged >= 2 ) {

    if( (x > ScaleX(w,w->x)) && (x < ScaleX(w,w->x+w->w)) && 
	(y > ScaleY(w,w->y)) && (y < ScaleY(w,w->y+w->h))     ) {
      maxlen = ((Stateg->w>=Stateg->h)?(Stateg->w/2):(Stateg->h/2));
      pthread_mutex_lock(&GuiLock);
      for(i=0; i<=maxlen; i++) {
	printf("(%d,%d,%d,%d,%0.4f,%0.4f,%0.4f) %d %0.4f %0.4f %0.4f\n",
	       Stateg->w,
	       Stateg->h,
	       Stateg->r1,
	       Stateg->r2,
	       Stateg->j1,
	       Stateg->j2,
	       Stateg->hv,
	       i,
	       Stateg->spatial_correlation[i],
	       Stateg->joint_entropy[i],
	       Stateg->mutual_information[i]);
      }
      fflush(stdout);
      pthread_mutex_unlock(&GuiLock);
    }
  }
}

void Write_Draw(widget_t *w)
{
  button_gui_t *b=(button_gui_t*)w->wd;

  // Outline
  Yellow();
  glBegin(GL_LINE_LOOP);
  glVertex2f(0.0f,0.0f);
  glVertex2f(0.0f,1.0f);
  glVertex2f(1.0f,1.0f);
  glVertex2f(1.0f,0.0f);
  glEnd();

  // Draw button label
  if( Stateg->converged >= 2 ) Green();
  else                         White();
  glRasterPos2f(0.5f-((strlen(b->text)*6.0f/2.0f)/ScaleX(w,w->w)), 0.5f+4.0f/ScaleY(w,w->h));
  printGLf(w->glw->font,"%s",b->text);
}

////////////////////////////////////////////////////////////////////////////////

// Key press callbacks

void Quit_Key(widget_t *w, char key, unsigned int keycode)
{
  if (key=='q') { GuiExit(); }
}


////////////////////////////////////////////////////////////////////////////////

